<?php
/**
 * File: app/Http/Controllers/BusinessController.php
 *
 * In the postBusinessSettings() method, add this code AFTER the default_pos_settings loop
 * and BEFORE the "// Save pos_settings as JSON" line.
 *
 * Search for: foreach ($default_pos_settings as $key => $value)
 * Add the password hashing code after the closing } of that foreach loop.
 */

// Existing code - for reference
$default_pos_settings = $this->businessUtil->defaultPosSettings();
foreach ($default_pos_settings as $key => $value) {
    if (! isset($pos_settings[$key])) {
        $pos_settings[$key] = $value;
    }
}

// ============================================
// ADD THIS CODE BLOCK - Hash delete invoice password
// ============================================
if (!empty($pos_settings['delete_invoice_password'])) {
    // Only hash if it's a new password (not already hashed)
    $existing_password = $pre_pos_setting['delete_invoice_password'] ?? '';
    if ($pos_settings['delete_invoice_password'] !== $existing_password) {
        $pos_settings['delete_invoice_password'] = \Hash::make($pos_settings['delete_invoice_password']);
    }
}
// ============================================

// Save pos_settings as JSON (existing code)
$business_details['pos_settings'] = json_encode($pos_settings);
