<?php
/**
 * File: app/Http/Controllers/SellPosController.php
 *
 * Replace the entire destroy() method with this updated version.
 * This adds password verification before allowing invoice deletion.
 */

/**
 * Remove the specified resource from storage.
 *
 * @param  int  $id
 * @return \Illuminate\Http\Response
 */
public function destroy($id)
{
    if (!auth()->user()->can('sell.delete') && !auth()->user()->can('direct_sell.delete') && !auth()->user()->can('so.delete')) {
        abort(403, 'Unauthorized action.');
    }

    if (request()->ajax()) {
        try {
            $business_id = request()->session()->get('user.business_id');

            // Check if delete invoice password protection is enabled
            $business = Business::find($business_id);
            $pos_settings = !empty($business->pos_settings) ? json_decode($business->pos_settings, true) : [];

            if (!empty($pos_settings['enable_delete_invoice_password'])) {
                $stored_password = $pos_settings['delete_invoice_password'] ?? '';
                $entered_password = request()->input('delete_invoice_password');

                if (empty($entered_password) || !\Hash::check($entered_password, $stored_password)) {
                    return [
                        'success' => false,
                        'msg' => trans('lang_v1.incorrect_delete_password')
                    ];
                }
            }

            //Begin transaction
            DB::beginTransaction();

            $output = $this->transactionUtil->deleteSale($business_id, $id);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            \Log::emergency('File:' . $e->getFile() . 'Line:' . $e->getLine() . 'Message:' . $e->getMessage());

            $output['success'] = false;
            $output['msg'] = trans('messages.something_went_wrong');
        }

        return $output;
    }
}
