/**
 * File: public/js/app.js
 *
 * Find the existing "//Delete Sale" section and replace it with this code.
 * This adds password protection when APP.DELETE_INVOICE_PASSWORD is true.
 */

//Delete Sale
$(document).on('click', '.delete-sale', function(e) {
    e.preventDefault();
    var href = $(this).attr('href');
    var is_suspended = $(this).hasClass('is_suspended');
    var enable_delete_password = (typeof APP !== 'undefined' && APP.DELETE_INVOICE_PASSWORD === true);

    // Function to perform the actual delete
    function performDelete(password) {
        var ajaxData = {};
        if (password) {
            ajaxData.delete_invoice_password = password;
        }
        $.ajax({
            method: 'DELETE',
            url: href,
            data: ajaxData,
            dataType: 'json',
            success: function(result) {
                if (result.success == true) {
                    toastr.success(result.msg);
                    if (typeof sell_table !== 'undefined') {
                        sell_table.ajax.reload();
                    }
                    if (typeof pending_repair_table !== 'undefined') {
                        pending_repair_table.ajax.reload();
                    }
                    //Displays list of recent transactions
                    if (typeof get_recent_transactions !== 'undefined') {
                        get_recent_transactions('final', $('div#tab_final'));
                        get_recent_transactions('draft', $('div#tab_draft'));
                    }
                    if (is_suspended) {
                        $('.view_modal').modal('hide');
                    }
                } else {
                    toastr.error(result.msg);
                }
            },
        });
    }

    if (enable_delete_password) {
        // Use native prompt to avoid DataTable interference
        var password = prompt(LANG.enter_password_to_delete);
        if (password === null) {
            return;
        }
        if (!password || password.trim() === '') {
            toastr.error(LANG.password_required);
            return;
        }
        performDelete(password);
    } else {
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                performDelete(null);
            }
        });
    }
});
