---
title: Delete Invoice Password Protection
sidebar_position: 1
---

# Delete Invoice Password Protection

This tutorial provides all the code files needed to implement password protection for deleting invoices in UltimatePOS.

## Files Overview

| File | Description |
|------|-------------|
| `settings_sales.blade.php` | Settings UI partial (add to existing file) |
| `javascripts.blade.php` | JavaScript variables (update existing file) |
| `app.js` | Delete sale handler (replace existing handler) |
| `lang_v1.php` | PHP language translations (add to existing file) |
| `en.js` | JavaScript language translations (add to existing file) |
| `BusinessController.php` | Password hashing logic (add to existing method) |
| `SellPosController.php` | Password verification (replace destroy method) |

## Installation Steps

1. Add translations to language files
2. Add settings UI to `settings_sales.blade.php`
3. Update `javascripts.blade.php` with APP variable
4. Replace delete sale handler in `app.js`
5. Add password hashing in `BusinessController.php`
6. Update `destroy` method in `SellPosController.php`
7. Clear cache and re-login

## Features

- Enable/disable password protection from Business Settings (Sale tab)
- Password is securely hashed using bcrypt
- Works on all delete invoice actions (Sells list, POS, etc.)
- Permission controlled via `business_settings.access`
