{{--
    File: resources/views/layouts/partials/javascripts.blade.php

    Replace the opening <script> section with this updated version.
    This adds the APP.DELETE_INVOICE_PASSWORD variable.
--}}

<script type="text/javascript">
    base_path = "{{ url('/') }}";
    //used for push notification
    APP = {};
    APP.PUSHER_APP_KEY = '{{ config('broadcasting.connections.pusher.key') }}';
    APP.PUSHER_APP_CLUSTER = '{{ config('broadcasting.connections.pusher.options.cluster') }}';
    APP.INVOICE_SCHEME_SEPARATOR = '{{ config('constants.invoice_scheme_separator') }}';
    //variable from app service provider
    APP.PUSHER_ENABLED = '{{ $__is_pusher_enabled }}';
    @auth
    @php
        $user = Auth::user();
        $pos_settings_json = session('business.pos_settings');
        $pos_settings_arr = !empty($pos_settings_json) ? json_decode($pos_settings_json, true) : [];
    @endphp
    APP.USER_ID = "{{ $user->id }}";
    APP.DELETE_INVOICE_PASSWORD = {{ !empty($pos_settings_arr['enable_delete_invoice_password']) ? 'true' : 'false' }};
    @else
        APP.USER_ID = '';
        APP.DELETE_INVOICE_PASSWORD = false;
    @endauth
</script>
