$(document).ready(function () {
    // Initialize Select2 for dashboard location with custom styling
    if ($('#dashboard_location').length > 0) {
        $('#dashboard_location').select2({
            placeholder: $('#dashboard_location').attr('placeholder'),
            allowClear: false,
            width: '100%',
            dropdownCssClass: 'dashboard-dropdown',
            containerCssClass: 'dashboard-select2-container'
        });
    }

    if ($('#dashboard_date_filter').length == 1) {
        dateRangeSettings.startDate = moment();
        dateRangeSettings.endDate = moment();
        $('#dashboard_date_filter').daterangepicker(dateRangeSettings, function (start, end) {
            $('#dashboard_date_filter span').html(
                start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
            );
            update_statistics(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            if ($('#quotation_table').length && $('#dashboard_location').length) {
                quotation_datatable.ajax.reload();
            }
        });

        update_statistics(moment().format('YYYY-MM-DD'), moment().format('YYYY-MM-DD'));
    }

    $('#dashboard_location').change(function (e) {
        var start = $('#dashboard_date_filter')
            .data('daterangepicker')
            .startDate.format('YYYY-MM-DD');

        var end = $('#dashboard_date_filter')
            .data('daterangepicker')
            .endDate.format('YYYY-MM-DD');

        update_statistics(start, end);
    });

    //Stock alert datatables
    var stock_alert_table = $('#stock_alert_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY: "75vh",
        scrollX: true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/product-stock-alert',
            "data": function (d) {
                if ($('#stock_alert_location').length > 0) {
                    d.location_id = $('#stock_alert_location').val();
                }
            }
        },
        fnDrawCallback: function (oSettings) {
            __currency_convert_recursively($('#stock_alert_table'));
        },
    });

    $('#stock_alert_location').change(function () {
        stock_alert_table.ajax.reload();
    });

    //Payment dues datatables
    purchase_payment_dues_table = $('#purchase_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY: "75vh",
        scrollX: true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/purchase-payment-dues',
            "data": function (d) {
                if ($('#purchase_payment_dues_location').length > 0) {
                    d.location_id = $('#purchase_payment_dues_location').val();
                }
            }
        },
        fnDrawCallback: function (oSettings) {
            __currency_convert_recursively($('#purchase_payment_dues_table'));
        },
    });

    $('#purchase_payment_dues_location').change(function () {
        purchase_payment_dues_table.ajax.reload();
    });

    //Sales dues datatables
    sales_payment_dues_table = $('#sales_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY: "75vh",
        scrollX: true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/sales-payment-dues',
            "data": function (d) {
                if ($('#sales_payment_dues_location').length > 0) {
                    d.location_id = $('#sales_payment_dues_location').val();
                }
            }
        },
        fnDrawCallback: function (oSettings) {
            __currency_convert_recursively($('#sales_payment_dues_table'));
        },
    });

    $('#sales_payment_dues_location').change(function () {
        sales_payment_dues_table.ajax.reload();
    });

    //Stock expiry report table
    stock_expiry_alert_table = $('#stock_expiry_alert_table').DataTable({
        processing: true,
        serverSide: true,
        searching: false,
        scrollY: "75vh",
        scrollX: true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            url: '/reports/stock-expiry',
            data: function (d) {
                d.exp_date_filter = $('#stock_expiry_alert_days').val();
            },
        },
        order: [[3, 'asc']],
        columns: [
            { data: 'product', name: 'p.name' },
            { data: 'location', name: 'l.name' },
            { data: 'stock_left', name: 'stock_left' },
            { data: 'exp_date', name: 'exp_date' },
        ],
        fnDrawCallback: function (oSettings) {
            __show_date_diff_for_human($('#stock_expiry_alert_table'));
            __currency_convert_recursively($('#stock_expiry_alert_table'));
        },
    });

    if ($('#quotation_table').length) {
        quotation_datatable = $('#quotation_table').DataTable({
            processing: true,
            serverSide: true,
            fixedHeader: false,
            aaSorting: [[0, 'desc']],
            "ajax": {
                "url": '/sells/draft-dt?is_quotation=1',
                "data": function (d) {
                    if ($('#dashboard_location').length > 0) {
                        d.location_id = $('#dashboard_location').val();
                    }
                }
            },
            columnDefs: [{
                "targets": 4,
                "orderable": false,
                "searchable": false
            }],
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'invoice_no', name: 'invoice_no' },
                { data: 'name', name: 'contacts.name' },
                { data: 'business_location', name: 'bl.name' },
                { data: 'action', name: 'action' }
            ]
        });
    }

    // Initialize dashboard animations
    initializeDashboardAnimations();
});

function update_statistics(start, end) {
    var location_id = '';
    if ($('#dashboard_location').length > 0) {
        location_id = $('#dashboard_location').val();
    }
    var data = { start: start, end: end, location_id: location_id };

    //Get purchase details with loading indicators
    var loader = '<i class="fas fa-sync fa-spin fa-fw margin-bottom"></i>';
    $('.total_purchase').html(loader);
    $('.purchase_due').html(loader);
    $('.total_sell').html(loader);
    $('.invoice_due').html(loader);
    $('.total_expense').html(loader);
    $('.total_purchase_return').html(loader);
    $('.total_sell_return').html(loader);
    $('.net').html(loader);

    // Show loading state for percentage badges
    $('.metric-badge').html('<i class="fas fa-spinner fa-spin"></i>');
    $('.status-indicator span').html('<i class="fas fa-spinner fa-spin"></i>');

    $.ajax({
        method: 'get',
        url: '/home/get-totals',
        dataType: 'json',
        data: data,
        success: function (data) {
            // Update main metric values
            $('.total_purchase').html(__currency_trans_from_en(data.total_purchase, true));
            $('.purchase_due').html(__currency_trans_from_en(data.purchase_due, true));
            $('.total_sell').html(__currency_trans_from_en(data.total_sell, true));
            $('.invoice_due').html(__currency_trans_from_en(data.invoice_due, true));
            $('.total_expense').html(__currency_trans_from_en(data.total_expense, true));
            $('.net').html(__currency_trans_from_en(data.net, true));

            // Calculate and display return values
            var total_purchase_return = data.total_purchase_return - data.total_purchase_return_paid;
            $('.total_purchase_return').html(__currency_trans_from_en(total_purchase_return, true));
            var total_sell_return_due = data.total_sell_return - data.total_sell_return_paid;
            $('.total_sell_return').html(__currency_trans_from_en(total_sell_return_due, true));
            $('.total_sr').html(__currency_trans_from_en(data.total_sell_return, true));
            $('.total_srp').html(__currency_trans_from_en(data.total_sell_return_paid, true));
            $('.total_pr').html(__currency_trans_from_en(data.total_purchase_return, true));
            $('.total_prp').html(__currency_trans_from_en(data.total_purchase_return_paid, true));

            // Update percentage badges with real data if available
            if (data.sell_change !== undefined) {
                updateMetricBadge('.metric-card:nth-child(1)', data.sell_change);
            }
            if (data.net_change !== undefined) {
                updateMetricBadge('.metric-card:nth-child(2)', data.net_change);
            }
            if (data.invoice_due_change !== undefined) {
                updateMetricBadge('.metric-card:nth-child(3)', data.invoice_due_change, true);
            }
            if (data.sell_return_change !== undefined) {
                updateMetricBadge('.metric-card:nth-child(4)', data.sell_return_change, true);
            }

            // Update secondary metrics status indicators
            if (data.purchase_change !== undefined) {
                updateStatusIndicator('.glass-card:nth-child(1)', data.purchase_change, 'from previous period');
            }
            if (data.purchase_due_change !== undefined) {
                updateStatusIndicator('.glass-card:nth-child(2)', data.purchase_due_change, 'suppliers pending', true);
            }
            if (data.purchase_return_change !== undefined) {
                updateStatusIndicator('.glass-card:nth-child(3)', data.purchase_return_change, 'from previous period');
            }
            if (data.expense_change !== undefined) {
                updateStatusIndicator('.glass-card:nth-child(4)', data.expense_change, 'from previous period', true);
            }

            // Update tooltips for sell return
            var lang = $('#total_srp').data('value');
            if (lang) {
                var splitlang = lang.split('-');
                var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_trans_from_en(data.total_sell_return, true) + "</span><br>" + splitlang[1] + ": <span class=''>" + __currency_trans_from_en(data.total_sell_return_paid, true) + "</span></p>";
                $('#total_srp').attr('data-content', newContent);
            }

            // Update tooltips for purchase return
            var lang = $('#total_prp').data('value');
            if (lang) {
                var splitlang = lang.split('-');
                var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_trans_from_en(data.total_purchase_return, true) + "</span><br>" + splitlang[1] + ": <span class=''>" + __currency_trans_from_en(data.total_purchase_return_paid, true) + "</span></p>";
                $('#total_prp').attr('data-content', newContent);
            }
        },
        error: function (xhr, status, error) {
            console.error('Error updating dashboard statistics:', error);

            // Reset loading indicators on error
            $('.total_purchase, .purchase_due, .total_sell, .invoice_due, .total_expense, .total_purchase_return, .total_sell_return, .net').html('--');
            $('.metric-badge').html('--');
            $('.status-indicator span').html('No data available');

            // Show error message
            if (typeof toastr !== 'undefined') {
                toastr.error('Error loading dashboard data. Please try again.');
            }
        }
    });
}

// Function to update metric badge with percentage and styling
function updateMetricBadge(cardSelector, percentageChange, reverseLogic = false) {
    var badge = $(cardSelector + ' .metric-badge');
    if (badge.length === 0) return;

    var isPositive = reverseLogic ? percentageChange <= 0 : percentageChange >= 0;
    var prefix = percentageChange >= 0 ? '+' : '';

    // Remove existing classes
    badge.removeClass('badge-positive badge-negative badge-urgent badge-warning');

    // Apply appropriate class based on logic
    if (reverseLogic) {
        // For metrics where lower is better (due amounts, returns)
        if (percentageChange <= 0) {
            badge.addClass('badge-positive');
        } else if (percentageChange > 20) {
            badge.addClass('badge-urgent');
        } else {
            badge.addClass('badge-warning');
        }
    } else {
        // For metrics where higher is better (sales, profit)
        if (percentageChange >= 0) {
            badge.addClass('badge-positive');
        } else {
            badge.addClass('badge-negative');
        }
    }

    // Update text with animation
    badge.fadeOut(200, function () {
        badge.text(prefix + percentageChange + '%').fadeIn(200);
    });
}

// Function to update status indicators in glass cards
function updateStatusIndicator(cardSelector, percentageChange, suffix = 'from previous period', reverseLogic = false) {
    var card = $(cardSelector);
    if (card.length === 0) return;

    var dot = card.find('.status-dot');
    var text = card.find('.status-indicator span');
    var prefix = percentageChange >= 0 ? '+' : '';
    var isPositive = reverseLogic ? percentageChange <= 0 : percentageChange >= 0;

    // Remove existing dot classes
    dot.removeClass('dot-green dot-red dot-yellow dot-blue');

    // Apply appropriate dot color
    if (isPositive) {
        dot.addClass('dot-green');
    } else if (Math.abs(percentageChange) > 20) {
        dot.addClass('dot-red');
    } else {
        dot.addClass('dot-yellow');
    }

    // Update text with animation
    text.fadeOut(200, function () {
        text.text(prefix + percentageChange + '% ' + suffix).fadeIn(200);
    });
}

// Initialize dashboard animations and effects
function initializeDashboardAnimations() {
    // Animate metric cards on load
    $('.metric-card, .glass-card').each(function (index) {
        var card = $(this);
        setTimeout(function () {
            card.css('opacity', '1').addClass('animate-slide-up');
        }, index * 100);
    });

    // Enhanced hover effects for metric cards
    $('.metric-card').hover(
        function () {
            $(this).find('.metric-icon').addClass('animate-pulse');
        },
        function () {
            $(this).find('.metric-icon').removeClass('animate-pulse');
        }
    );

    // Enhanced hover effects for glass cards
    $('.glass-card').hover(
        function () {
            $(this).find('.glass-icon').addClass('animate-bounce');
        },
        function () {
            $(this).find('.glass-icon').removeClass('animate-bounce');
        }
    );
}

// Utility function for smooth number transitions
function animateNumber(element, from, to, duration = 1000) {
    var start = performance.now();
    var startVal = parseFloat(from) || 0;
    var endVal = parseFloat(to) || 0;

    function updateNumber(timestamp) {
        var elapsed = timestamp - start;
        var progress = Math.min(elapsed / duration, 1);

        // Easing function for smooth animation
        var easeOutQuart = 1 - Math.pow(1 - progress, 4);
        var currentVal = startVal + (endVal - startVal) * easeOutQuart;

        element.text(__currency_trans_from_en(currentVal, true));

        if (progress < 1) {
            requestAnimationFrame(updateNumber);
        }
    }

    requestAnimationFrame(updateNumber);
}

// Auto-refresh functionality (optional)
var autoRefreshInterval;
function startAutoRefresh() {
    autoRefreshInterval = setInterval(function () {
        if ($('#dashboard_date_filter').length) {
            var start = $('#dashboard_date_filter')
                .data('daterangepicker')
                .startDate.format('YYYY-MM-DD');
            var end = $('#dashboard_date_filter')
                .data('daterangepicker')
                .endDate.format('YYYY-MM-DD');
            update_statistics(start, end);
        }
    }, 300000); // 5 minutes
}

function stopAutoRefresh() {
    if (autoRefreshInterval) {
        clearInterval(autoRefreshInterval);
    }
}

// Start auto-refresh when user is active
var isUserActive = true;
var inactivityTimer;

$(document).on('mousemove keypress', function () {
    isUserActive = true;
    clearTimeout(inactivityTimer);

    if (!autoRefreshInterval) {
        startAutoRefresh();
    }

    inactivityTimer = setTimeout(function () {
        isUserActive = false;
        stopAutoRefresh();
    }, 600000); // Stop after 10 minutes of inactivity
});

// Handle page visibility change (pause/resume auto-refresh)
document.addEventListener('visibilitychange', function () {
    if (document.hidden) {
        stopAutoRefresh();
    } else if (isUserActive) {
        startAutoRefresh();
    }
});

// Keyboard shortcuts for dashboard
$(document).keydown(function (e) {
    // Ctrl/Cmd + D to open date filter
    if ((e.ctrlKey || e.metaKey) && e.which === 68) {
        e.preventDefault();
        $('#dashboard_date_filter').click();
    }

    // Ctrl/Cmd + R to refresh dashboard
    if ((e.ctrlKey || e.metaKey) && e.which === 82) {
        e.preventDefault();
        if ($('#dashboard_date_filter').length) {
            var start = $('#dashboard_date_filter')
                .data('daterangepicker')
                .startDate.format('YYYY-MM-DD');
            var end = $('#dashboard_date_filter')
                .data('daterangepicker')
                .endDate.format('YYYY-MM-DD');
            update_statistics(start, end);
        }
    }
});

// Start auto-refresh on page load
$(window).on('load', function () {
    if (isUserActive) {
        startAutoRefresh();
    }
});

// Expose functions globally for external use
window.update_statistics = update_statistics;
window.updateMetricBadge = updateMetricBadge;
window.updateStatusIndicator = updateStatusIndicator;