@extends('layouts.app')
@section('title', __('home.home'))

@section('content')

{{-- Modern POS Dashboard Widgets --}}
<div class="relative min-h-screen">
    <!-- Modern Gradient Background -->
    <div class="absolute inset-0 tw-bg-gradient-to-br tw-from-indigo-900 tw-via-purple-900 tw-to-pink-800"></div>
    <div class="absolute inset-0 tw-bg-gradient-to-tr tw-from-blue-800/20 tw-via-transparent tw-to-emerald-800/20">
    </div>

    <div class="modern-dashboard">
        <!-- Header Section -->
        <div class="dashboard-header">
            <h1 class="welcome-title">
                {{ __('home.welcome_message', ['name' => Session::get('user.first_name')]) }}
            </h1>
            <p class="welcome-subtitle">Here's your business overview for today</p>

            @if (auth()->user()->can('dashboard.data') || $is_admin)
            <div class="controls-wrapper">
                @if (count($all_locations) > 1)
                <div class="control-element">
                    {!! Form::select('dashboard_location', $all_locations, null, [
                    'class' => 'control-element',
                    'placeholder' => __('lang_v1.select_location'),
                    'id' => 'dashboard_location',
                    'style' => 'background: none; border: none; color: white;'
                    ]) !!}
                </div>
                @endif

                <button type="button" id="dashboard_date_filter" class="control-element">
                    <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        style="display: inline; margin-right: 8px;">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    {{ __('messages.filter_by_date') }}
                </button>
            </div>
            @endif
        </div>

        @if (auth()->user()->can('dashboard.data') || $is_admin)
        <!-- Main Metrics -->
        <div class="metrics-grid">
            <!-- Total Sales -->
            <div class="metric-card" style="animation-delay: 0.1s;">
                <div class="metric-header">
                    <div class="metric-icon icon-sales">
                        <svg width="24" height="24" fill="none" stroke="white" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-2.5 5M7 13l2.5 5m0 0h8" />
                        </svg>
                    </div>
                    <div
                        class="metric-badge {{ $today_data['sell_change'] >= 0 ? 'badge-positive' : 'badge-negative' }}">
                        {{ $today_data['sell_change'] >= 0 ? '+' : '' }}{{ $today_data['sell_change'] }}%
                    </div>
                </div>
                <div class="metric-content">
                    <div class="metric-label">{{ __('home.total_sell') }}</div>
                    <div class="metric-value total_sell">
                        <span class="display_currency" data-currency_symbol="true">{{ $today_data['total_sell']
                            }}</span>
                    </div>
                    <div class="metric-subtitle">vs previous period</div>
                </div>
            </div>

            <!-- Net Profit -->
            <div class="metric-card" style="animation-delay: 0.2s;">
                <div class="metric-header">
                    <div class="metric-icon icon-profit">
                        <svg width="24" height="24" fill="none" stroke="white" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 8h6m-5 0a3 3 0 110 6H9l3 3m-3-6h6m6 1a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div
                        class="metric-badge {{ $today_data['net_change'] >= 0 ? 'badge-positive' : 'badge-negative' }}">
                        {{ $today_data['net_change'] >= 0 ? '+' : '' }}{{ $today_data['net_change'] }}%
                    </div>
                </div>
                <div class="metric-content">
                    <div class="metric-label">
                        {{ __('lang_v1.net') }} @show_tooltip(__('lang_v1.net_home_tooltip'))
                    </div>
                    <div class="metric-value net">
                        <span class="display_currency" data-currency_symbol="true">{{ $today_data['net'] }}</span>
                    </div>
                    <div class="metric-subtitle">vs previous period</div>
                </div>
            </div>

            <!-- Invoice Due -->
            <div class="metric-card" style="animation-delay: 0.3s;">
                <div class="metric-header">
                    <div class="metric-icon icon-invoice">
                        <svg width="24" height="24" fill="none" stroke="white" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </div>
                    <div
                        class="metric-badge {{ $today_data['invoice_due_change'] <= 0 ? 'badge-positive' : 'badge-urgent' }}">
                        {{ $today_data['invoice_due_change'] >= 0 ? '+' : '' }}{{ $today_data['invoice_due_change'] }}%
                    </div>
                </div>
                <div class="metric-content">
                    <div class="metric-label">{{ __('home.invoice_due') }}</div>
                    <div class="metric-value invoice_due">
                        <span class="display_currency" data-currency_symbol="true">{{ $today_data['invoice_due']
                            }}</span>
                    </div>
                    <div class="metric-subtitle">pending invoices</div>
                </div>
            </div>

            <!-- Sales Return -->
            <div class="metric-card" style="animation-delay: 0.4s;">
                <div class="metric-header">
                    <div class="metric-icon icon-return">
                        <svg width="24" height="24" fill="none" stroke="white" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M16 15v-1a4 4 0 00-4-4H8m0 0l3 3m-3-3l3-3" />
                        </svg>
                    </div>
                    <div
                        class="metric-badge {{ $today_data['sell_return_change'] <= 0 ? 'badge-positive' : 'badge-negative' }}">
                        {{ $today_data['sell_return_change'] >= 0 ? '+' : '' }}{{ $today_data['sell_return_change'] }}%
                    </div>
                </div>
                <div class="metric-content">
                    <div class="metric-label">
                        {{ __('lang_v1.total_sell_return') }}
                        <i class="fa fa-info-circle text-info hover-q no-print" aria-hidden="true" data-container="body"
                            data-toggle="popover" data-placement="auto bottom" id="total_srp"
                            data-value="{{ __('lang_v1.total_sell_return') }}-{{ __('lang_v1.total_sell_return_paid') }}"
                            data-content="" data-html="true" data-trigger="hover"></i>
                    </div>
                    <div class="metric-value total_sell_return">
                        <span class="display_currency" data-currency_symbol="true">{{ $today_data['total_sell_return']
                            }}</span>
                    </div>
                    <div class="metric-subtitle">vs previous period</div>
                </div>
            </div>
        </div>

        <!-- Secondary Metrics -->
        <div class="secondary-metrics">
            <!-- Total Purchase -->
            <div class="glass-card" style="animation-delay: 0.5s;">
                <div class="glass-header">
                    <div class="glass-icon">
                        <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 14l-7 7m0 0l-7-7m7 7V3" />
                        </svg>
                    </div>
                    <div class="glass-content">
                        <h3>{{ __('home.total_purchase') }}</h3>
                        <div class="value total_purchase">
                            <span class="display_currency" data-currency_symbol="true">{{ $today_data['total_purchase']
                                }}</span>
                        </div>
                    </div>
                </div>
                <div class="status-indicator">
                    <div class="status-dot {{ $today_data['purchase_change'] >= 0 ? 'dot-green' : 'dot-red' }}"></div>
                    <span>{{ $today_data['purchase_change'] >= 0 ? '+' : '' }}{{ $today_data['purchase_change'] }}% from
                        previous period</span>
                </div>
            </div>

            <!-- Purchase Due -->
            <div class="glass-card" style="animation-delay: 0.6s;">
                <div class="glass-header">
                    <div class="glass-icon">
                        <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div class="glass-content">
                        <h3>{{ __('home.purchase_due') }}</h3>
                        <div class="value purchase_due">
                            <span class="display_currency" data-currency_symbol="true">{{ $today_data['purchase_due']
                                }}</span>
                        </div>
                    </div>
                </div>
                <div class="status-indicator">
                    <div class="status-dot {{ $today_data['purchase_due_change'] <= 0 ? 'dot-green' : 'dot-yellow' }}">
                    </div>
                    <span>{{ $today_data['purchase_due_change'] >= 0 ? '+' : '' }}{{ $today_data['purchase_due_change']
                        }}% suppliers pending</span>
                </div>
            </div>

            <!-- Purchase Return -->
            <div class="glass-card" style="animation-delay: 0.7s;">
                <div class="glass-header">
                    <div class="glass-icon">
                        <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 15l3-3m0 0l3 3m-3-3v12" />
                        </svg>
                    </div>
                    <div class="glass-content">
                        <h3>
                            {{ __('lang_v1.total_purchase_return') }}
                            <i class="fa fa-info-circle text-info hover-q no-print" aria-hidden="true"
                                data-container="body" data-toggle="popover" data-placement="auto bottom" id="total_prp"
                                data-value="{{ __('lang_v1.total_purchase_return') }}-{{ __('lang_v1.total_purchase_return_paid') }}"
                                data-content="" data-html="true" data-trigger="hover"></i>
                        </h3>
                        <div class="value total_purchase_return">
                            <span class="display_currency" data-currency_symbol="true">{{
                                $today_data['total_purchase_return'] }}</span>
                        </div>
                    </div>
                </div>
                <div class="status-indicator">
                    <div class="status-dot {{ $today_data['purchase_return_change'] >= 0 ? 'dot-green' : 'dot-red' }}">
                    </div>
                    <span>{{ $today_data['purchase_return_change'] >= 0 ? '+' : '' }}{{
                        $today_data['purchase_return_change'] }}% from previous period</span>
                </div>
            </div>

            <!-- Total Expenses -->
            <div class="glass-card" style="animation-delay: 0.8s;">
                <div class="glass-header">
                    <div class="glass-icon">
                        <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                        </svg>
                    </div>
                    <div class="glass-content">
                        <h3>{{ __('lang_v1.expense') }}</h3>
                        <div class="value total_expense">
                            <span class="display_currency" data-currency_symbol="true">{{ $today_data['total_expense']
                                }}</span>
                        </div>
                    </div>
                </div>
                <div class="status-indicator">
                    <div class="status-dot {{ $today_data['expense_change'] <= 0 ? 'dot-green' : 'dot-blue' }}"></div>
                    <span>{{ $today_data['expense_change'] >= 0 ? '+' : '' }}{{ $today_data['expense_change'] }}% from
                        previous period</span>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@if (auth()->user()->can('dashboard.data'))
<div class="tw-px-5 tw-py-6">
    <div class="tw-grid tw-grid-cols-1 tw-gap-4 sm:tw-gap-5 lg:tw-grid-cols-2">
        @if (auth()->user()->can('sell.view') || auth()->user()->can('direct_sell.view'))
        @if (!empty($all_locations))
        <div
            class="tw-transition-all lg:tw-col-span-2 xl:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-size-5 tw-text-sky-500 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M6 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M17 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M17 17h-11v-14h-2"></path>
                            <path d="M6 5l14 1l-1 7h-13"></path>
                        </svg>
                    </div>

                    <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                        {{ __('home.sells_last_30_days') }}
                    </h3>
                </div>
                <div class="tw-mt-5">
                    <div
                        class="tw-grid tw-w-full tw-h-100 tw-border tw-border-gray-200 tw-border-dashed tw-rounded-xl tw-bg-gray-50 ">
                        <p class="tw-text-sm tw-italic tw-font-normal tw-text-gray-400">
                            {!! $sells_chart_1->container() !!}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        @endif

        @if (!empty($all_locations))
        <div
            class="tw-transition-all lg:tw-col-span-2 xl:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-size-5 tw-text-sky-500 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M6 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M17 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M17 17h-11v-14h-2"></path>
                            <path d="M6 5l14 1l-1 7h-13"></path>
                        </svg>
                    </div>
                    <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                        {{ __('home.sells_current_fy') }}
                    </h3>
                </div>
                <div class="tw-mt-5">
                    <div
                        class="tw-grid tw-w-full tw-h-100 tw-border tw-border-gray-200 tw-border-dashed tw-rounded-xl tw-bg-gray-50 ">
                        <p class="tw-text-sm tw-italic tw-font-normal tw-text-gray-400">
                            {!! $sells_chart_2->container() !!}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endif

        {{-- Rest of your existing dashboard tables and widgets --}}
        @if (auth()->user()->can('sell.view') || auth()->user()->can('direct_sell.view'))
        <div
            class="tw-transition-all lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M12 9v4"></path>
                            <path
                                d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                            </path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                {{ __('lang_v1.sales_payment_dues') }}
                                @show_tooltip(__('lang_v1.tooltip_sales_payment_dues'))
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            {!! Form::select('sales_payment_dues_location', $all_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'sales_payment_dues_location',
                            ]) !!}
                        </div>
                    </div>
                </div>

                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped" id="sales_payment_dues_table"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('contact.customer')</th>
                                        <th>@lang('sale.invoice_no')</th>
                                        <th>@lang('home.due_amount')</th>
                                        <th>@lang('messages.action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        @can('purchase.view')
        <div
            class="tw-transition-all lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M12 9v4"></path>
                            <path
                                d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                            </path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                {{ __('lang_v1.purchase_payment_dues') }}
                                @show_tooltip(__('tooltip.payment_dues'))
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            {!! Form::select('purchase_payment_dues_location', $all_locations, null, [
                            'class' => 'form-control select2 ',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'purchase_payment_dues_location',
                            ]) !!}
                            @endif
                        </div>
                    </div>

                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped" id="purchase_payment_dues_table"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('purchase.supplier')</th>
                                        <th>@lang('purchase.ref_no')</th>
                                        <th>@lang('home.due_amount')</th>
                                        <th>@lang('messages.action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endcan
        @can('stock_report.view')
        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
                            <path d="M12 8v4"></path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                {{ __('home.product_stock_alert') }}
                                @show_tooltip(__('tooltip.product_stock_alert'))
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            {!! Form::select('stock_alert_location', $all_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'stock_alert_location',
                            ]) !!}
                            @endif
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped" id="stock_alert_table"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('sale.product')</th>
                                        <th>@lang('business.location')</th>
                                        <th>@lang('report.current_stock')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if (session('business.enable_product_expiry') == 1)
        <div
            class="tw-transition-all lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M12 9v4"></path>
                            <path
                                d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                            </path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                {{ __('home.stock_expiry_alert') }}
                                @show_tooltip(
                                __('tooltip.stock_expiry_alert', [
                                'days'
                                =>session('business.stock_expiry_alert_days', 30) ]) )
                            </h3>
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <input type="hidden" id="stock_expiry_alert_days"
                                value="{{ \Carbon::now()->addDays(session('business.stock_expiry_alert_days', 30))->format('Y-m-d') }}">
                            <table class="table table-bordered table-striped" id="stock_expiry_alert_table">
                                <thead>
                                    <tr>
                                        <th>@lang('business.product')</th>
                                        <th>@lang('business.location')</th>
                                        <th>@lang('report.stock_left')</th>
                                        <th>@lang('product.expires_in')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endcan
        @if (auth()->user()->can('so.view_all') || auth()->user()->can('so.view_own'))
        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
                            <path d="M12 8v4"></path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                {{ __('lang_v1.sales_order') }}
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            {!! Form::select('so_location', $all_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'so_location',
                            ]) !!}
                            @endif
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped ajax_view" id="sales_order_table">
                                <thead>
                                    <tr>
                                        <th>@lang('messages.action')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('restaurant.order_no')</th>
                                        <th>@lang('sale.customer_name')</th>
                                        <th>@lang('lang_v1.contact_no')</th>
                                        <th>@lang('sale.location')</th>
                                        <th>@lang('sale.status')</th>
                                        <th>@lang('lang_v1.shipping_status')</th>
                                        <th>@lang('lang_v1.quantity_remaining')</th>
                                        <th>@lang('lang_v1.added_by')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @if (
        !empty($common_settings['enable_purchase_requisition']) &&
        (auth()->user()->can('purchase_requisition.view_all') || auth()->user()->can('purchase_requisition.view_own')))
        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M10 10v4a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-4"></path>
                            <path d="M9 6h6"></path>
                            <path d="M10 6v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2"></path>
                            <circle cx="12" cy="16" r="2"></circle>
                            <path d="M5 20h14a2 2 0 0 0 2 -2v-10"></path>
                            <path d="M15 16v4"></path>
                            <path d="M9 20v-4"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                @lang('lang_v1.purchase_requisition')
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            @if (count($all_locations) > 1)
                            {!! Form::select('pr_location', $all_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'pr_location',
                            ]) !!}
                            @endif
                            @endif
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped ajax_view" id="purchase_requisition_table"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('messages.action')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('purchase.ref_no')</th>
                                        <th>@lang('purchase.location')</th>
                                        <th>@lang('sale.status')</th>
                                        <th>@lang('lang_v1.required_by_date')</th>
                                        <th>@lang('lang_v1.added_by')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        @if (
        !empty($common_settings['enable_purchase_order']) &&
        (auth()->user()->can('purchase_order.view_all') || auth()->user()->can('purchase_order.view_own')))

        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                            <rect x="4" y="4" width="16" height="16" rx="2" />
                            <line x1="4" y1="10" x2="20" y2="10" />
                            <line x1="12" y1="4" x2="12" y2="20" />
                            <line x1="12" y1="10" x2="16" y2="10" />
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                @lang('lang_v1.purchase_order')
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            {!! Form::select('po_location', $all_locations, null, [
                            'class' => 'form-control select2',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'po_location',
                            ]) !!}
                            @endif
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped ajax_view" id="purchase_order_table"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>@lang('messages.action')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('purchase.ref_no')</th>
                                        <th>@lang('purchase.location')</th>
                                        <th>@lang('purchase.supplier')</th>
                                        <th>@lang('sale.status')</th>
                                        <th>@lang('lang_v1.quantity_remaining')</th>
                                        <th>@lang('lang_v1.added_by')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @endif
        @if (auth()->user()->can('access_pending_shipments_only') ||
        auth()->user()->can('access_shipping') ||
        auth()->user()->can('access_own_shipping'))
        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                            <path d="M5 17h-2v-4m-1 -8h11v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5"></path>
                            <path d="M3 9l4 0"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                @lang('lang_v1.pending_shipments')
                            </h3>
                        </div>
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            @if (count($all_locations) > 1)
                            {!! Form::select('pending_shipments_location', $all_locations, null, [
                            'class' => 'form-control select2 ',
                            'placeholder' => __('lang_v1.select_location'),
                            'id' => 'pending_shipments_location',
                            ]) !!}
                            @endif
                        </div>
                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped ajax_view" id="shipments_table">
                                <thead>
                                    <tr>
                                        <th>@lang('messages.action')</th>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('sale.invoice_no')</th>
                                        <th>@lang('sale.customer_name')</th>
                                        <th>@lang('lang_v1.contact_no')</th>
                                        <th>@lang('sale.location')</th>
                                        <th>@lang('lang_v1.shipping_status')</th>
                                        @if (!empty($custom_labels['shipping']['custom_field_1']))
                                        <th>
                                            {{ $custom_labels['shipping']['custom_field_1'] }}
                                        </th>
                                        @endif
                                        @if (!empty($custom_labels['shipping']['custom_field_2']))
                                        <th>
                                            {{ $custom_labels['shipping']['custom_field_2'] }}
                                        </th>
                                        @endif
                                        @if (!empty($custom_labels['shipping']['custom_field_3']))
                                        <th>
                                            {{ $custom_labels['shipping']['custom_field_3'] }}
                                        </th>
                                        @endif
                                        @if (!empty($custom_labels['shipping']['custom_field_4']))
                                        <th>
                                            {{ $custom_labels['shipping']['custom_field_4'] }}
                                        </th>
                                        @endif
                                        @if (!empty($custom_labels['shipping']['custom_field_5']))
                                        <th>
                                            {{ $custom_labels['shipping']['custom_field_5'] }}
                                        </th>
                                        @endif
                                        <th>@lang('sale.payment_status')</th>
                                        <th>@lang('restaurant.service_staff')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        @if (auth()->user()->can('account.access') && config('constants.show_payments_recovered_today') == true)
        <div
            class="tw-transition-all lg:tw-col-span-2 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw--translate-y-0.5 tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2.5">
                    <div class="tw-border-2 tw-flex tw-items-center tw-justify-center tw-rounded-full tw-w-10 tw-h-10">
                        <svg aria-hidden="true" class="tw-text-yellow-500 tw-size-5 tw-shrink-0"
                            xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M12 9v4"></path>
                            <path
                                d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z">
                            </path>
                            <path d="M12 16h.01"></path>
                        </svg>
                    </div>
                    <div class="tw-flex tw-items-center tw-flex-1 tw-min-w-0 tw-gap-1">
                        <div class="tw-w-full sm:tw-w-1/2 md:tw-w-1/2">
                            <h3 class="tw-font-bold tw-text-base lg:tw-text-xl">
                                @lang('lang_v1.payment_recovered_today')
                            </h3>
                        </div>

                    </div>
                </div>
                <div class="tw-flow-root tw-mt-5  tw-border-gray-200">
                    <div class="tw--mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-striped" id="cash_flow_table">
                                <thead>
                                    <tr>
                                        <th>@lang('messages.date')</th>
                                        <th>@lang('account.account')</th>
                                        <th>@lang('lang_v1.description')</th>
                                        <th>@lang('lang_v1.payment_method')</th>
                                        <th>@lang('lang_v1.payment_details')</th>
                                        <th>@lang('account.credit')</th>
                                        <th>@lang('lang_v1.account_balance')
                                            @show_tooltip(__('lang_v1.account_balance_tooltip'))</th>
                                        <th>@lang('lang_v1.total_balance')
                                            @show_tooltip(__('lang_v1.total_balance_tooltip'))</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr class="bg-gray font-17 footer-total text-center">
                                        <td colspan="5"><strong>@lang('sale.total'):</strong></td>
                                        <td class="footer_total_credit"></td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

    </div>
</div>
@endif

@endsection

{{-- Continue with all your existing modals, CSS, and JavaScript --}}
<div class="modal fade payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade edit_pso_status_modal" tabindex="-1" role="dialog"></div>
<div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
</div>

@section('css')
<style>
    .select2-container {
        width: 100% !important;
    }
</style>
{{-- Your existing CSS styles remain the same --}}
<style>
    /* Custom CSS that works without Tailwind */
    .modern-dashboard {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 2rem;
    }

    .dashboard-header {
        margin-bottom: 2rem;
        animation: fadeInUp 0.6s ease-out;
    }

    .header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }

    .welcome-section {
        flex: 1;
        min-width: 300px;
    }

    .welcome-title {
        color: white;
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .welcome-subtitle {
        color: rgba(255, 255, 255, 0.8);
        font-size: 1.1rem;
        margin-bottom: 0;
    }

    .controls-wrapper {
        display: flex;
        gap: 1rem;
        flex-wrap: wrap;
        align-items: center;
    }

    .control-element-wrapper {
        position: relative;
    }

    /* Hide the original select element styling */
    .control-select {
        display: none !important;
    }

    /* Style the Select2 container directly with specific classes */
    .dashboard-select2-container {
        min-width: 180px !important;
    }

    .dashboard-select2-container .select2-selection--single {
        background: rgba(255, 255, 255, 0.15) !important;
        backdrop-filter: blur(10px) !important;
        border: 1px solid rgba(255, 255, 255, 0.2) !important;
        border-radius: 12px !important;
        height: 48px !important;
        transition: all 0.3s ease !important;
        box-shadow: none !important;
    }

    .dashboard-select2-container .select2-selection--single:hover {
        background: rgba(255, 255, 255, 0.25) !important;
        transform: translateY(-2px);
        border-color: rgba(255, 255, 255, 0.3) !important;
    }

    .dashboard-select2-container .select2-selection--single .select2-selection__rendered {
        color: white !important;
        line-height: 46px !important;
        padding-left: 20px !important;
        padding-right: 40px !important;
        font-size: 14px !important;
    }

    .dashboard-select2-container .select2-selection--single .select2-selection__placeholder {
        color: rgba(255, 255, 255, 0.8) !important;
    }

    .dashboard-select2-container .select2-selection--single .select2-selection__arrow {
        height: 46px !important;
        right: 15px !important;
        width: 20px !important;
    }

    .dashboard-select2-container .select2-selection--single .select2-selection__arrow b {
        border-color: rgba(255, 255, 255, 0.8) transparent transparent transparent !important;
        border-style: solid !important;
        border-width: 5px 4px 0 4px !important;
        height: 0 !important;
        left: 50% !important;
        margin-left: -4px !important;
        margin-top: -2px !important;
        position: absolute !important;
        top: 50% !important;
        width: 0 !important;
    }

    /* Custom dropdown styling with specific class */
    .dashboard-dropdown {
        background: white !important;
        border: 1px solid rgba(0, 0, 0, 0.1) !important;
        border-radius: 12px !important;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
        margin-top: 4px !important;
        overflow: hidden !important;
    }

    .dashboard-dropdown .select2-results>.select2-results__options {
        max-height: 200px !important;
        border-radius: 12px !important;
        padding: 8px 0 !important;
    }

    .dashboard-dropdown .select2-results__option {
        padding: 12px 20px !important;
        color: #333 !important;
        background: white !important;
        border: none !important;
        font-size: 14px !important;
        transition: all 0.2s ease !important;
    }

    .dashboard-dropdown .select2-results__option--highlighted {
        background: #667eea !important;
        color: white !important;
    }

    .dashboard-dropdown .select2-results__option[aria-selected=true] {
        background: #f8f9fa !important;
        color: #333 !important;
        font-weight: 500 !important;
    }

    .dashboard-dropdown .select2-results__option:hover {
        background: #667eea !important;
        color: white !important;
    }

    .dashboard-dropdown .select2-search {
        padding: 8px 12px !important;
        background: #f8f9fa !important;
        border-bottom: 1px solid #e9ecef !important;
    }

    .dashboard-dropdown .select2-search__field {
        border: 1px solid #dee2e6 !important;
        border-radius: 6px !important;
        padding: 8px 12px !important;
        width: 100% !important;
        box-sizing: border-box !important;
    }

    /* Control element styling */
    .control-element {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        padding: 12px 20px;
        color: white;
        transition: all 0.3s ease;
        cursor: pointer;
        display: flex;
        align-items: center;
        text-decoration: none;
    }

    .control-element:hover {
        background: rgba(255, 255, 255, 0.25);
        transform: translateY(-2px);
        color: white;
        text-decoration: none;
    }


    .select2-container--default .select2-results__option:last-child {
        border-bottom-left-radius: 12px;
        border-bottom-right-radius: 12px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .header-content {
            flex-direction: column;
            align-items: flex-start;
        }

        .welcome-section {
            min-width: auto;
            width: 100%;
        }

        .welcome-title {
            font-size: 2rem;
        }

        .controls-wrapper {
            width: 100%;
            justify-content: flex-start;
        }

        .control-select {
            min-width: 150px;
        }
    }

    @media (max-width: 480px) {
        .controls-wrapper {
            flex-direction: column;
            width: 100%;
        }

        .control-element-wrapper,
        .control-element {
            width: 100%;
        }

        .control-select {
            min-width: auto;
        }
    }

    .metrics-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .metric-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
        animation: slideInUp 0.6s ease-out forwards;
        opacity: 0;
    }

    .metric-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    .metric-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #667eea, #764ba2);
    }

    .metric-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .metric-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        transition: transform 0.3s ease;
    }

    .metric-icon:hover {
        transform: scale(1.1);
    }

    .icon-sales {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    }

    .icon-profit {
        background: linear-gradient(135deg, #10b981, #047857);
    }

    .icon-invoice {
        background: linear-gradient(135deg, #f59e0b, #d97706);
    }

    .icon-return {
        background: linear-gradient(135deg, #ef4444, #dc2626);
    }

    .metric-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        margin-left: auto;
    }

    .badge-positive {
        background: #dcfce7;
        color: #166534;
    }

    .badge-negative {
        background: #fee2e2;
        color: #991b1b;
    }

    .badge-warning {
        background: #fef3c7;
        color: #92400e;
    }

    .badge-urgent {
        background: #fee2e2;
        color: #991b1b;
    }

    .metric-content {
        flex: 1;
    }

    .metric-label {
        color: #6b7280;
        font-size: 0.9rem;
        font-weight: 500;
        margin-bottom: 0.5rem;
    }

    .metric-value {
        color: #111827;
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 0.25rem;
        font-family: 'Segoe UI', system-ui, sans-serif;
    }

    .metric-subtitle {
        color: #9ca3af;
        font-size: 0.8rem;
    }

    /* Secondary metrics with glass effect */
    .secondary-metrics {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
    }

    .glass-card {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(15px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 16px;
        padding: 1.5rem;
        color: white;
        transition: all 0.3s ease;
        animation: slideInUp 0.6s ease-out forwards;
        opacity: 0;
    }

    .glass-card:hover {
        background: rgba(255, 255, 255, 0.25);
        transform: translateY(-4px);
    }

    .glass-header {
        display: flex;
        align-items: center;
        margin-bottom: 1rem;
    }

    .glass-icon {
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
    }

    .glass-content h3 {
        color: rgba(255, 255, 255, 0.8);
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }

    .glass-content .value {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .status-indicator {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.85rem;
        margin-top: 1rem;
    }

    .status-dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
    }

    .dot-green {
        background: #34d399;
    }

    .dot-yellow {
        background: #fbbf24;
    }

    .dot-red {
        background: #f87171;
    }

    .dot-blue {
        background: #60a5fa;
    }

    /* Animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(50px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 768px) {
        .modern-dashboard {
            padding: 1rem;
        }

        .welcome-title {
            font-size: 2rem;
        }

        .metrics-grid {
            grid-template-columns: 1fr;
        }

        .secondary-metrics {
            grid-template-columns: 1fr;
        }
    }

    @media (min-width: 1200px) {
        .metrics-grid {
            grid-template-columns: repeat(4, 1fr);
        }

        .secondary-metrics {
            grid-template-columns: repeat(4, 1fr);
        }
    }
</style>
@endsection

@section('javascript')
<script src="{{ asset('js/home.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/payment.js?v=' . $asset_v) }}"></script>
@includeIf('sales_order.common_js')
@includeIf('purchase_order.common_js')
@if (!empty($all_locations))
{!! $sells_chart_1->script() !!}
{!! $sells_chart_2->script() !!}
@endif

<script type="text/javascript">
    $(document).ready(function() {
    // Function to update dashboard data
    function updateDashboardData() {
        var start_date = $('#dashboard_date_filter').data('start_date');
        var end_date = $('#dashboard_date_filter').data('end_date');
        var location_id = $('#dashboard_location').val();

        $.ajax({
            method: 'GET',
            url: '{{ action([\App\Http\Controllers\HomeController::class, "getTotals"]) }}',
            dataType: 'json',
            data: {
                start: start_date,
                end: end_date,
                location_id: location_id
            },
            success: function(data) {
                // Update metric values
                $('.total_sell .display_currency').text(__currency_trans_from_en(data.total_sell, true));
                $('.net .display_currency').text(__currency_trans_from_en(data.net, true));
                $('.invoice_due .display_currency').text(__currency_trans_from_en(data.invoice_due, true));
                $('.total_sell_return .display_currency').text(__currency_trans_from_en(data.total_sell_return, true));
                $('.total_purchase .display_currency').text(__currency_trans_from_en(data.total_purchase, true));
                $('.purchase_due .display_currency').text(__currency_trans_from_en(data.purchase_due, true));
                $('.total_purchase_return .display_currency').text(__currency_trans_from_en(data.total_purchase_return, true));
                $('.total_expense .display_currency').text(__currency_trans_from_en(data.total_expense, true));

                // Update percentage badges
                updateBadge('.metric-card:nth-child(1) .metric-badge', data.sell_change);
                updateBadge('.metric-card:nth-child(2) .metric-badge', data.net_change);
                updateBadge('.metric-card:nth-child(3) .metric-badge', data.invoice_due_change, true); // Reverse logic for due
                updateBadge('.metric-card:nth-child(4) .metric-badge', data.sell_return_change, true); // Reverse logic for returns

                // Update secondary metrics status indicators
                updateStatusIndicator('.glass-card:nth-child(1)', data.purchase_change);
                updateStatusIndicator('.glass-card:nth-child(2)', data.purchase_due_change, true);
                updateStatusIndicator('.glass-card:nth-child(3)', data.purchase_return_change);
                updateStatusIndicator('.glass-card:nth-child(4)', data.expense_change, true);
            }
        });
    }

    // Function to update badge appearance and text
    function updateBadge(selector, value, reverse = false) {
        var badge = $(selector);
        var isPositive = reverse ? value <= 0 : value >= 0;
        var prefix = value >= 0 ? '+' : '';

        badge.removeClass('badge-positive badge-negative badge-urgent');
        badge.addClass(isPositive ? 'badge-positive' : 'badge-negative');
        badge.text(prefix + value + '%');
    }

    // Function to update status indicator
    function updateStatusIndicator(selector, value, reverse = false) {
        var card = $(selector);
        var isPositive = reverse ? value <= 0 : value >= 0;
        var prefix = value >= 0 ? '+' : '';
        var dot = card.find('.status-dot');
        var text = card.find('.status-indicator span');

        dot.removeClass('dot-green dot-red dot-yellow dot-blue');
        if (isPositive) {
            dot.addClass('dot-green');
        } else {
            dot.addClass('dot-red');
        }

        text.text(prefix + value + '% from previous period');
    }

    // Date filter event
    $('#dashboard_date_filter').on('apply.daterangepicker', function(ev, picker) {
        $(this).data('start_date', picker.startDate.format('YYYY-MM-DD'));
        $(this).data('end_date', picker.endDate.format('YYYY-MM-DD'));
        updateDashboardData();
    });

    // Location filter event
    $('#dashboard_location').change(function() {
        updateDashboardData();
    });

            sales_order_table = $('#sales_order_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader:false,
                scrollY: "75vh",
                scrollX: true,
                scrollCollapse: true,
                aaSorting: [
                    [1, 'desc']
                ],
                "ajax": {
                    "url": '{{ action([\App\Http\Controllers\SellController::class, 'index']) }}?sale_type=sales_order',
                    "data": function(d) {
                        d.for_dashboard_sales_order = true;

                        if ($('#so_location').length > 0) {
                            d.location_id = $('#so_location').val();
                        }
                    }
                },
                columnDefs: [{
                    "targets": 7,
                    "orderable": false,
                    "searchable": false
                }],
                columns: [{
                        data: 'action',
                        name: 'action'
                    },
                    {
                        data: 'transaction_date',
                        name: 'transaction_date'
                    },
                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'conatct_name',
                        name: 'conatct_name'
                    },
                    {
                        data: 'mobile',
                        name: 'contacts.mobile'
                    },
                    {
                        data: 'business_location',
                        name: 'bl.name'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'shipping_status',
                        name: 'shipping_status'
                    },
                    {
                        data: 'so_qty_remaining',
                        name: 'so_qty_remaining',
                        "searchable": false
                    },
                    {
                        data: 'added_by',
                        name: 'u.first_name'
                    },
                ]
            });

            @if (auth()->user()->can('account.access') && config('constants.show_payments_recovered_today') == true)

                // Cash Flow Table
                cash_flow_table = $('#cash_flow_table').DataTable({
                    processing: true,
                    serverSide: true,
                    fixedHeader:false,
                    "ajax": {
                        "url": "{{ action([\App\Http\Controllers\AccountController::class, 'cashFlow']) }}",
                        "data": function(d) {
                            d.type = 'credit';
                            d.only_payment_recovered = true;
                        }
                    },
                    "ordering": false,
                    "searching": false,
                    columns: [{
                            data: 'operation_date',
                            name: 'operation_date'
                        },
                        {
                            data: 'account_name',
                            name: 'account_name'
                        },
                        {
                            data: 'sub_type',
                            name: 'sub_type'
                        },
                        {
                            data: 'method',
                            name: 'TP.method'
                        },
                        {
                            data: 'payment_details',
                            name: 'payment_details',
                            searchable: false
                        },
                        {
                            data: 'credit',
                            name: 'amount'
                        },
                        {
                            data: 'balance',
                            name: 'balance'
                        },
                        {
                            data: 'total_balance',
                            name: 'total_balance'
                        },
                    ],
                    "fnDrawCallback": function(oSettings) {
                        __currency_convert_recursively($('#cash_flow_table'));
                    },
                    "footerCallback": function(row, data, start, end, display) {
                        var footer_total_credit = 0;

                        for (var r in data) {
                            footer_total_credit += $(data[r].credit).data('orig-value') ? parseFloat($(
                                data[r].credit).data('orig-value')) : 0;
                        }
                        $('.footer_total_credit').html(__currency_trans_from_en(footer_total_credit));
                    }
                });
            @endif

            $('#so_location').change(function() {
                sales_order_table.ajax.reload();
            });
            @if (!empty($common_settings['enable_purchase_order']))
                //Purchase table
                purchase_order_table = $('#purchase_order_table').DataTable({
                    processing: true,
                    serverSide: true,
                    fixedHeader:false,
                    aaSorting: [
                        [1, 'desc']
                    ],
                    scrollY: "75vh",
                    scrollX: true,
                    scrollCollapse: true,
                    ajax: {
                        url: '{{ action([\App\Http\Controllers\PurchaseOrderController::class, 'index']) }}',
                        data: function(d) {
                            d.from_dashboard = true;

                            if ($('#po_location').length > 0) {
                                d.location_id = $('#po_location').val();
                            }
                        },
                    },
                    columns: [{
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'transaction_date',
                            name: 'transaction_date'
                        },
                        {
                            data: 'ref_no',
                            name: 'ref_no'
                        },
                        {
                            data: 'location_name',
                            name: 'BS.name'
                        },
                        {
                            data: 'name',
                            name: 'contacts.name'
                        },
                        {
                            data: 'status',
                            name: 'transactions.status'
                        },
                        {
                            data: 'po_qty_remaining',
                            name: 'po_qty_remaining',
                            "searchable": false
                        },
                        {
                            data: 'added_by',
                            name: 'u.first_name'
                        }
                    ]
                })

                $('#po_location').change(function() {
                    purchase_order_table.ajax.reload();
                });
            @endif

            @if (!empty($common_settings['enable_purchase_requisition']))
                //Purchase table
                purchase_requisition_table = $('#purchase_requisition_table').DataTable({
                    processing: true,
                    serverSide: true,
                    fixedHeader:false,
                    aaSorting: [
                        [1, 'desc']
                    ],
                    scrollY: "75vh",
                    scrollX: true,
                    scrollCollapse: true,
                    ajax: {
                        url: '{{ action([\App\Http\Controllers\PurchaseRequisitionController::class, 'index']) }}',
                        data: function(d) {
                            d.from_dashboard = true;

                            if ($('#pr_location').length > 0) {
                                d.location_id = $('#pr_location').val();
                            }
                        },
                    },
                    columns: [{
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'transaction_date',
                            name: 'transaction_date'
                        },
                        {
                            data: 'ref_no',
                            name: 'ref_no'
                        },
                        {
                            data: 'location_name',
                            name: 'BS.name'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: 'delivery_date',
                            name: 'delivery_date'
                        },
                        {
                            data: 'added_by',
                            name: 'u.first_name'
                        },
                    ]
                })

                $('#pr_location').change(function() {
                    purchase_requisition_table.ajax.reload();
                });

                $(document).on('click', 'a.delete-purchase-requisition', function(e) {
                    e.preventDefault();
                    swal({
                        title: LANG.sure,
                        icon: 'warning',
                        buttons: true,
                        dangerMode: true,
                    }).then(willDelete => {
                        if (willDelete) {
                            var href = $(this).attr('href');
                            $.ajax({
                                method: 'DELETE',
                                url: href,
                                dataType: 'json',
                                success: function(result) {
                                    if (result.success == true) {
                                        toastr.success(result.msg);
                                        purchase_requisition_table.ajax.reload();
                                    } else {
                                        toastr.error(result.msg);
                                    }
                                },
                            });
                        }
                    });
                });
            @endif

            sell_table = $('#shipments_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader:false,
                aaSorting: [
                    [1, 'desc']
                ],
                scrollY: "75vh",
                scrollX: true,
                scrollCollapse: true,
                "ajax": {
                    "url": '{{ action([\App\Http\Controllers\SellController::class, 'index']) }}',
                    "data": function(d) {
                        d.only_pending_shipments = true;
                        if ($('#pending_shipments_location').length > 0) {
                            d.location_id = $('#pending_shipments_location').val();
                        }
                    }
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        searchable: false,
                        orderable: false
                    },
                    {
                        data: 'transaction_date',
                        name: 'transaction_date'
                    },
                    {
                        data: 'invoice_no',
                        name: 'invoice_no'
                    },
                    {
                        data: 'conatct_name',
                        name: 'conatct_name'
                    },
                    {
                        data: 'mobile',
                        name: 'contacts.mobile'
                    },
                    {
                        data: 'business_location',
                        name: 'bl.name'
                    },
                    {
                        data: 'shipping_status',
                        name: 'shipping_status'
                    },
                    @if (!empty($custom_labels['shipping']['custom_field_1']))
                        {
                            data: 'shipping_custom_field_1',
                            name: 'shipping_custom_field_1'
                        },
                    @endif
                    @if (!empty($custom_labels['shipping']['custom_field_2']))
                        {
                            data: 'shipping_custom_field_2',
                            name: 'shipping_custom_field_2'
                        },
                    @endif
                    @if (!empty($custom_labels['shipping']['custom_field_3']))
                        {
                            data: 'shipping_custom_field_3',
                            name: 'shipping_custom_field_3'
                        },
                    @endif
                    @if (!empty($custom_labels['shipping']['custom_field_4']))
                        {
                            data: 'shipping_custom_field_4',
                            name: 'shipping_custom_field_4'
                        },
                    @endif
                    @if (!empty($custom_labels['shipping']['custom_field_5']))
                        {
                            data: 'shipping_custom_field_5',
                            name: 'shipping_custom_field_5'
                        },
                    @endif {
                        data: 'payment_status',
                        name: 'payment_status'
                    },
                    {
                        data: 'waiter',
                        name: 'ss.first_name',
                        @if (empty($is_service_staff_enabled))
                            visible: false
                        @endif
                    }
                ],
                "fnDrawCallback": function(oSettings) {
                    __currency_convert_recursively($('#sell_table'));
                },
                createdRow: function(row, data, dataIndex) {
                    $(row).find('td:eq(4)').attr('class', 'clickable_td');
                }
            });

            $('#pending_shipments_location').change(function() {
                sell_table.ajax.reload();
            });
        });

           // Animation timing
    const cards = document.querySelectorAll('.metric-card, .glass-card');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.style.opacity = '1';
        }, index * 100);
    });
</script>


{{-- JavaScript for enhanced interactions --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {


    // Enhanced hover effects for glass elements
    const glassElements = document.querySelectorAll('[class*="tw-bg-white/10"]');
    glassElements.forEach(element => {
        element.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
            this.style.boxShadow = '0 10px 25px rgba(0,0,0,0.1)';
        });

        element.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = '';
        });
    });
});
</script>
<script>
    // Animation timing
document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.metric-card, .glass-card');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.style.opacity = '1';
        }, index * 100);
    });
});
</script>
@endsection
