<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business', function (Blueprint $table) {
            $table->boolean('purchase_item_addition_method')->default(1)->after('item_addition_method');
            $table->boolean('adjustment_item_addition_method')->default(1)->after('purchase_item_addition_method');
            $table->boolean('transfer_item_addition_method')->default(1)->after('adjustment_item_addition_method');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business', function (Blueprint $table) {
            $table->dropColumn(['purchase_item_addition_method', 'adjustment_item_addition_method', 'transfer_item_addition_method']);
        });
    }
};
