// Sub unit change handler - Add stock display update
// Find this section in pos.js and add the qty_available_el update

if (base_max_avlbl) {
    var max_avlbl = parseFloat(base_max_avlbl) / multiplier;
    var formated_max_avlbl = __number_f(max_avlbl);
    var unit_name = selected_option.data('unit_name');
    var max_err_msg = __translate(error_msg_line, {
        max_val: formated_max_avlbl,
        unit_name: unit_name,
    });
    qty_element.attr('data-rule-max-value', max_avlbl);
    qty_element.attr('data-msg-max-value', max_err_msg);
    qty_element.rules('add', {
        'max-value': max_avlbl,
        messages: {
            'max-value': max_err_msg,
        },
    });

    // Update the stock display text with available quantity
    var qty_available_el = tr.find('.qty_available_text');
    if (qty_available_el.length) {
        qty_available_el.text(__currency_trans_from_en(max_avlbl, false));
    }

    qty_element.trigger('change');
}
adjustComboQty(tr);
