<!-- Product History Modal -->
<div class="modal fade" id="product_history_modal" tabindex="-1" role="dialog" aria-labelledby="product_history_modal_label">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title text-white" id="product_history_modal_label">
                    <i class="fas fa-history"></i> @lang('lang_v1.product_history')
                </h4>
            </div>
            <div class="modal-body">
                <!-- Search Box -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="product_history_search">@lang('lang_v1.search_product_by_sku')</label>
                            <div class="input-group">
                                <input type="text" id="product_history_search" class="form-control"
                                    placeholder="@lang('lang_v1.enter_sku_or_product_name')" autofocus>
                                <span class="input-group-btn">
                                    <button class="btn btn-primary" type="button" id="search_product_history_btn">
                                        <i class="fa fa-search"></i> @lang('lang_v1.search')
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div id="product_history_info" class="well well-sm" style="display:none; margin-top: 25px;">
                            <div class="row">
                                <div class="col-xs-3">
                                    <img id="product_history_image" src="" class="img-responsive img-thumbnail" style="max-height: 80px;">
                                </div>
                                <div class="col-xs-9">
                                    <strong id="product_history_name"></strong><br>
                                    <small><b>@lang('product.sku'):</b> <span id="product_history_sku"></span></small><br>
                                    <small><b>@lang('lang_v1.current_stock'):</b> <span id="product_history_stock" class="text-success"></span></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- History Tabs -->
                <div id="product_history_tabs_container" style="display:none;">
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#sales_history_tab" aria-controls="sales_history_tab" role="tab" data-toggle="tab">
                                <i class="fas fa-shopping-cart text-success"></i> @lang('lang_v1.sales_history')
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#purchase_history_tab" aria-controls="purchase_history_tab" role="tab" data-toggle="tab">
                                <i class="fas fa-truck text-primary"></i> @lang('lang_v1.purchase_history')
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#stock_history_tab" aria-controls="stock_history_tab" role="tab" data-toggle="tab">
                                <i class="fas fa-cubes text-info"></i> @lang('lang_v1.stock_history')
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#warranty_history_tab" aria-controls="warranty_history_tab" role="tab" data-toggle="tab">
                                <i class="fas fa-shield-alt text-warning"></i> @lang('lang_v1.warranty_info')
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#expiry_history_tab" aria-controls="expiry_history_tab" role="tab" data-toggle="tab">
                                <i class="fas fa-calendar-times text-danger"></i> @lang('lang_v1.expiry_info')
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content" style="padding-top: 15px;">
                        <!-- Sales History Tab -->
                        <div role="tabpanel" class="tab-pane active" id="sales_history_tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-condensed" id="sales_history_table">
                                    <thead>
                                        <tr class="bg-light-blue">
                                            <th>@lang('sale.invoice_no')</th>
                                            <th>@lang('messages.date')</th>
                                            <th>@lang('contact.customer')</th>
                                            <th>@lang('sale.qty')</th>
                                            <th>@lang('sale.unit_price')</th>
                                            <th>@lang('sale.subtotal')</th>
                                            <th>@lang('sale.location')</th>
                                        </tr>
                                    </thead>
                                    <tbody id="sales_history_body">
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                @lang('lang_v1.search_product_to_see_history')
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="sales_pagination" class="text-center"></div>
                        </div>

                        <!-- Purchase History Tab -->
                        <div role="tabpanel" class="tab-pane" id="purchase_history_tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-condensed" id="purchase_history_table">
                                    <thead>
                                        <tr class="bg-light-green">
                                            <th>@lang('purchase.ref_no')</th>
                                            <th>@lang('messages.date')</th>
                                            <th>@lang('purchase.supplier')</th>
                                            <th>@lang('sale.qty')</th>
                                            <th>@lang('lang_v1.purchase_price')</th>
                                            <th>@lang('sale.subtotal')</th>
                                            <th>@lang('sale.location')</th>
                                        </tr>
                                    </thead>
                                    <tbody id="purchase_history_body">
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                @lang('lang_v1.search_product_to_see_history')
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="purchases_pagination" class="text-center"></div>
                        </div>

                        <!-- Stock History Tab -->
                        <div role="tabpanel" class="tab-pane" id="stock_history_tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-condensed" id="stock_history_table">
                                    <thead>
                                        <tr class="bg-aqua">
                                            <th>@lang('messages.date')</th>
                                            <th>@lang('lang_v1.transaction_type')</th>
                                            <th>@lang('purchase.ref_no')</th>
                                            <th>@lang('sale.location')</th>
                                            <th>@lang('lang_v1.qty_in')</th>
                                            <th>@lang('lang_v1.qty_out')</th>
                                            <th>@lang('lang_v1.balance')</th>
                                        </tr>
                                    </thead>
                                    <tbody id="stock_history_body">
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                @lang('lang_v1.search_product_to_see_history')
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="stock_pagination" class="text-center"></div>
                        </div>

                        <!-- Warranty History Tab -->
                        <div role="tabpanel" class="tab-pane" id="warranty_history_tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-condensed" id="warranty_history_table">
                                    <thead>
                                        <tr class="bg-yellow">
                                            <th>@lang('sale.invoice_no')</th>
                                            <th>@lang('messages.date')</th>
                                            <th>@lang('contact.customer')</th>
                                            <th>@lang('lang_v1.warranty')</th>
                                            <th>@lang('lang_v1.warranty_start')</th>
                                            <th>@lang('lang_v1.warranty_end')</th>
                                            <th>@lang('lang_v1.status')</th>
                                        </tr>
                                    </thead>
                                    <tbody id="warranty_history_body">
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                @lang('lang_v1.search_product_to_see_history')
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="warranty_pagination" class="text-center"></div>
                        </div>

                        <!-- Expiry History Tab -->
                        <div role="tabpanel" class="tab-pane" id="expiry_history_tab">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-condensed" id="expiry_history_table">
                                    <thead>
                                        <tr class="bg-red">
                                            <th>@lang('lang_v1.lot_number')</th>
                                            <th>@lang('lang_v1.exp_date')</th>
                                            <th>@lang('sale.location')</th>
                                            <th>@lang('lang_v1.current_stock')</th>
                                            <th>@lang('lang_v1.days_to_expiry')</th>
                                            <th>@lang('lang_v1.status')</th>
                                        </tr>
                                    </thead>
                                    <tbody id="expiry_history_body">
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                @lang('lang_v1.search_product_to_see_history')
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="expiry_pagination" class="text-center"></div>
                        </div>
                    </div>
                </div>

                <!-- Loading indicator -->
                <div id="product_history_loading" style="display:none; text-align:center; padding: 50px;">
                    <i class="fa fa-spinner fa-spin fa-3x"></i>
                    <p>@lang('lang_v1.loading')...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
            </div>
        </div>
    </div>
</div>
